/*
 *  Arnold emulator (c) Copyright, Kevin Thacker 1995-2015
 *
 *  This file is part of the Arnold emulator source code distribution.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../cpc/cpcglob.h"

typedef enum
{
	JOYSTICK_HARDWARE_AMX_MOUSE = 0,
	JOYSTICK_HARDWARE_JOYSTICK,
	JOYSTICK_HARDWARE_WESTPHASER,
	JOYSTICK_HARDWARE_SPANISH_LIGHTGUN
} JOYSTICK_HARDWARE_ID;


/* dk tronics 256k ram expansion */
#define CPC_RAM_CONFIG_256K_RAM				0x0002
/* dk tronics 256k silicon disk expansion */
#define CPC_RAM_CONFIG_256K_SILICON_DISK	0x0004
/* dk'tronics 64k expansion or 2nd bank of 64k in CPC6128 */
#define CPC_RAM_CONFIG_64K_RAM				0x0001
			
#define CPC_RAM_BLOCK_0_MASK				(1<<0)
#define CPC_RAM_BLOCK_1_MASK				(1<<1)
#define CPC_RAM_BLOCK_2_MASK				(1<<2)
#define CPC_RAM_BLOCK_3_MASK				(1<<3)
#define CPC_RAM_BLOCK_4_MASK				(1<<4)
#define CPC_RAM_BLOCK_5_MASK				(1<<5)
#define CPC_RAM_BLOCK_6_MASK				(1<<6)
#define CPC_RAM_BLOCK_7_MASK				(1<<7)
#define CPC_RAM_BLOCK_8_MASK				(1<<8)
#define CPC_RAM_BLOCK_9_MASK				(1<<9)
#define CPC_RAM_BLOCK_10_MASK				(1<<10)
#define CPC_RAM_BLOCK_11_MASK				(1<<11)
#define CPC_RAM_BLOCK_12_MASK				(1<<12)
#define CPC_RAM_BLOCK_13_MASK				(1<<13)
#define CPC_RAM_BLOCK_14_MASK				(1<<14)
#define CPC_RAM_BLOCK_15_MASK				(1<<15)
#define CPC_RAM_BLOCK_16_MASK				(1<<16)
#define CPC_RAM_BLOCK_17_MASK				(1<<17)
#define CPC_RAM_BLOCK_18_MASK				(1<<18)
#define CPC_RAM_BLOCK_19_MASK				(1<<19)
#define CPC_RAM_BLOCK_20_MASK				(1<<20)
#define CPC_RAM_BLOCK_21_MASK				(1<<21)
#define CPC_RAM_BLOCK_22_MASK				(1<<22)
#define CPC_RAM_BLOCK_23_MASK				(1<<23)
#define CPC_RAM_BLOCK_24_MASK				(1<<24)
#define CPC_RAM_BLOCK_25_MASK				(1<<25)
#define CPC_RAM_BLOCK_26_MASK				(1<<26)
#define CPC_RAM_BLOCK_27_MASK				(1<<27)
#define CPC_RAM_BLOCK_28_MASK				(1<<28)
#define CPC_RAM_BLOCK_29_MASK				(1<<29)
#define CPC_RAM_BLOCK_30_MASK				(1<<30)
#define CPC_RAM_BLOCK_31_MASK				(1<<31)
			
			
			
void Amstrad_DiscInterface_Install(void);
void Amstrad_DiscInterface_DeInstall(void);
void	Amstrad_RamExpansion_Install(void);
void	Amstrad_RamExpansion_DeInstall(void);
			
void CPC_SetRamConfig(unsigned long);
unsigned long CPC_GetRamConfig(void);
			
void ROM_SetSelectedROMIndex(Z80_BYTE Data);
Z80_BYTE ROM_GetSelectedROMIndex(void);
			
void    CPC_ReleaseKeys(void);
			
void CPC_SetOSRom(const unsigned char *pOSRom,unsigned long Length);
void CPC_SetBASICRom(const unsigned char *pBASICROM,unsigned long Length);
void CPC_SetDOSRom(const unsigned char *pDOSRom);
unsigned char * Get_Amstrad_ExtraRam(void);
		
void CPC_SetRamConfig(unsigned long);
unsigned long CPC_GetRamConfig(void);

